﻿/*
Copyright © 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/
var timer = null;
var mtimer = null;
var editable = false;
var backside = false;
var autoFont = true;
var kMinFontSize = 10;
var gTextHeight = 0;
var gMaxSize = 162;
var savedHTML;
var gCurrentFontSize;
var gCurrentFont;

function getLocalizedString (key)
{
	try {
		var ret = localizedStrings[key];
		if (ret == undefined)
			ret = key;
		return ret;
	} catch (ex) {}

	return key;
}

function focus ()
{
	if (!editable)
	{
		document.getElementById("edit-div").contentEditable = true;
		editable = true;
	}
}

function blur ()
{
	var eDiv = document.getElementById("edit-div");
	if (editable)
	{
		eDiv.contentEditable = false;
		editable = false;
	}
	eDiv.style.height = gTextHeight + "px";
}

function onhide ()
{
	blur();
}

function selectall ()
{
	var element = document.getElementById ("front");
	window.getSelection().setBaseAndExtent(element.firstChild, 0, element.lastChild, element.lastChild.length);
}

function createkey(key)
{
	return widget.identifier + "-" + key;
}


function writeSticky ()
{
	widget.setPreferenceForKey(document.getElementById("edit-div").innerHTML, createkey("data"));
}

function onremove ()
{
	// remove my instance preferences when remove from dashboard
	widget.setPreferenceForKey(null, createkey("data"));
	widget.setPreferenceForKey(null, createkey("color"));
	widget.setPreferenceForKey(null, createkey("font"));
	widget.setPreferenceForKey(null, createkey("size"));
}

window.onfocus = focus;
window.onblur = blur;

if (window.widget)
{
	widget.onhide = onhide;
	widget.onremove = onremove;
}

function showbackside(event)
{
	var front = document.getElementById("front");
	var back = document.getElementById("behind");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");
	
	front.style.display="none";
	back.style.display="block";
	document.body.removeEventListener("click", editclick, false);
	
	if (window.widget)		
		setTimeout ('widget.performTransition();', 0);	

	backside = true;
	
	document.getElementById('fliprollie').style.display = 'none';
}

function editclick (event)
{
	var eDiv = document.getElementById("edit-div");
	if (!editable)
	{
		eDiv.contentEditable = true;
		editable = true;
	}
	eDiv.style.height = "";
	if (!myContainCheck(eDiv, event.target)) {
		window.getSelection().setBaseAndExtent(0, 0, document.getElementById("front").lastChild, 0);
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
}

function doneMouseUp(event)
{
	var front = document.getElementById("front");
	var back = document.getElementById("behind");
	var eDiv = document.getElementById("edit-div");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	gTextHeight = eDiv.offsetHeight;
	if (autoFont) {
		updateElems(eDiv);
		changeFontOfElement(eDiv);
		setMaxSize(element.style.fontSize);
	}
	
	document.body.addEventListener("click", editclick, false);
	back.style.display="none";
	eDiv.style.height = gTextHeight + "px";
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
	backside = false;
}

function clickoncolor (event, color)
{
	document.body.style.backgroundImage = "url(" + color + ")";
	if (window.widget)
	{
		widget.setPreferenceForKey(color, createkey("color"));
	}
	positioncheck (color);
}

function fontchanged (elem)
{	
	var font = elem.options[elem.selectedIndex].value;
	
	document.getElementById("edit-div").style.fontFamily = font;
	gCurrentFont = font;
	
	if (window.widget)
	{
		widget.setPreferenceForKey(font, createkey("font"));
	}
}

function sizechanged(elem)
{	
	var size;
	if (elem.selectedIndex == 1) elem.selectedIndex = 0; // separator
	size = elem.options[elem.selectedIndex].value;
		
	if (size == "Auto") {
		autoFont = true;
	} else {
		document.getElementById("edit-div").style.fontSize = size;
		gCurrentFontSize = size;
		setMaxSize(size);
		autoFont = false;
	}
	
	if (window.widget)
	{
		widget.setPreferenceForKey(size, createkey("size"));
	}
	
}

function positioncheck (color)
{
	var elem = document.getElementById("check");
	
	var array = new Array;
	
	array["Images/yellow.png"] = {left:"19px", top:"28px"};
	array["Images/orange.png"] = {left:"58px", top:"28px"};
	array["Images/green.png"] = {left:"97px", top:"28px"};
	array["Images/green2.png"] = {left:"136px", top:"28px"};
	array["Images/blue2.png"] = {left:"175px", top:"28px"};
	
	array["Images/blue.png"] = {left:"19px", top:"60px"};
	array["Images/purple1.png"] = {left:"58px", top:"60px"};
	array["Images/pink.png"] = {left:"97px", top:"60px"};
	array["Images/white.png"] = {left:"136px", top:"60px"};
	array["Images/grey.png"] = {left:"175px", top:"60px"};
	
	var obj = array[color];
	if (obj == null)
		obj = {left:"19px", top:"28px"};
	
	elem.style.top = obj.top;
	elem.style.left = obj.left;
}

var flipShown = false;

var animation = {duration:0, starttime:0, to:0.5, now:0.0, from:0.0, element:null, timer:null};

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.element.style.opacity = animation.now;
}


function mousemove (event)
{
	if (!flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.element = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.5;
		animate();
		flipShown = true;
	}
	
	if (!editable)
	{
		document.getElementById("edit-div").contentEditable = true;
		editable = true;
	}
}

function mouseexit (event)
{
	if (flipShown)
	{
		// fade out the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.element = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}

function onclickOverride (event)
{
	var element = event.target.parentNode;
	while (element && (element != document.getElementById("edit-div"))) {
		if (element.nodeName == "A") // its a link
		{
			if (window.widget)
				widget.openURL(element.getAttribute("href"));
			
			event.stopPropagation();
			event.preventDefault();
			
			return true;
		}
		element = element.parentNode;
	}
}

var nodeInserted = false;
function mutationEvent (event)
{
	gTextHeight = document.getElementById("edit-div").offsetHeight;
	if ((event.type == "DOMNodeRemoved") && (event.target.nodeName != "DIV")) {
		return;
	}
	
	if (event.type == "DOMNodeInserted")
		nodeInserted = true;
	
	if (timer != null)
		clearTimeout (timer);
	
	timer = setTimeout('writeSticky();', 5000);
	
	if (mtimer != null)
		clearTimeout(mtimer);
	
	mtimer = setTimeout('mutationTimer();', 0);
}

function mutationTimer() {
	var eDiv = document.getElementById("edit-div");
	
	if (nodeInserted) {
		updateElems(eDiv);
		nodeInserted = false;
	}

	if (autoFont)
		changeFontOfElement(eDiv);
	
	var savedHeight = gTextHeight;
	gTextHeight = eDiv.offsetHeight;
	if ( (gTextHeight > gMaxSize) &&
		 (! autoFont || (parseInt(eDiv.style.fontSize) == kMinFontSize)) ) {
		eDiv.innerHTML = savedHTML;
		gTextHeight = savedHeight;
	}
}

// roomToGrow is a misnomer in the non-autoFont case, but is used at the
// bottom of the sticky to determine is a return/linefeed is OK
function roomToGrow() {
	var rtg = false;
	var eDiv = document.getElementById("edit-div");
	
	gTextHeight = eDiv.offsetHeight;
	if (autoFont)
		rtg = ((parseInt(eDiv.style.fontSize) > kMinFontSize) ||
				  ((parseInt(eDiv.style.fontSize) == kMinFontSize) && (gTextHeight < (gMaxSize - kMinFontSize - 1))));
	else
		rtg = ((gTextHeight + parseInt(eDiv.style.fontSize)) < 161);
				  
	return rtg;
}

function loaded ()
{
	// only need to check for mutation events if we are in the dashboard
	if (window.widget)
	{
		var element = document.getElementById('edit-div');
		element.addEventListener ("DOMCharacterDataModified", mutationEvent, false);
		element.addEventListener ("DOMNodeInserted", mutationEvent, false);
		element.addEventListener ("DOMNodeRemoved", mutationEvent, false);
		document.body.addEventListener("click", editclick, false);
		
		element.style.height = element.offsetHeight > 0? element.offsetHeight: "20px";
		gTextHeight = parseInt(element.style.height);
		gCurrentFontSize = element.style.fontSize? element.style.fontSize: "18px";
		gCurrentFont = element.style.fontFamily? element.style.fontFamily: "MarkerFelt-thin";

		var data = widget.preferenceForKey(createkey("size"));
		if ((data != null) && (data != "Auto"))
			autoFont = false;
		
		if (autoFont) {
			updateElems(element);
			changeFontOfElement(element);
		}
		setMaxSize(element.style.fontSize);

		// add localizedFonts to pop-up menu
		try {
			if (localizedFonts)
			{
				var fontPopup = document.getElementById('font-popup');
				var i;
				for (i=0; i<localizedFonts.length; i++)
				{
					var fontName = localizedFonts[i];
					var optionElement = document.createElement('option');
					optionElement.setAttribute('value', fontName);
	
					var localizedName = localizedFonts[fontName];
					if (!localizedName)
						continue;
					optionElement.innerHTML = localizedName;
					
					fontPopup.appendChild(optionElement);
				}
			}
		} catch(ex) {}
		
		gCurrentFont = element.style.fontFamily;
	}
}

function keydown (event)
{
	var eDiv = document.getElementById('edit-div');
	
	if (parseInt(eDiv.style.height) == gTextHeight) eDiv.style.height = "";
	
	if (event.metaKey && String.fromCharCode(event.charCode) == 'a')
	{
		selectall();
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	if (event.charCode == 8 /* delete */) {
		if ( (eDiv.innerText.length == 0) ||
			 ((eDiv.innerText.length == 1) && (eDiv.innerText.charCodeAt(0) == 10)) ) {
			// This prevents WebCore editing from deleting all the elements if there
			// is no text. If this gets fixed, this can be removed. This doesn't
			// prevent the case where there is text.
			event.stopPropagation();
			event.preventDefault();
			return false;
		}
	}
	
	// Reject return/linefeeds at the bottom
	if (((event.charCode == 3) || (event.charCode == 13)) &&
		!roomToGrow()) {
		event.stopPropagation();
		event.preventDefault();
		return false;
	}
	if (savedHTML == eDiv.innerHTML)
		return false;
	else
		savedHTML = eDiv.innerHTML;
}

document.addEventListener("keydown", keydown, true);

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function setMaxSize(fontSize) {
	var fs = parseInt(fontSize);
	
	if (fs < 18)
		fs += 1;
	else
		fs += 2;
	gMaxSize = fs * parseInt(162/fs);
	document.getElementById("edit-div").style.clip = "rect(auto auto " + gMaxSize + "px auto)";
}

function updateElems(element) {
	element.style.fontSize = gCurrentFontSize;
	element.style.fontFamily = gCurrentFont;

	var elemsInDiv = element.getElementsByTagName("span");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].style.fontSize = "";
		elemsInDiv[i].style.fontFamily = "";
	}
	elemsInDiv = element.getElementsByTagName("div");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].style.fontSize = "";
		elemsInDiv[i].style.fontFamily = "";
	}
	elemsInDiv = element.getElementsByTagName("p");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].style.fontSize = "";
		elemsInDiv[i].style.fontFamily = "";
	}
	elemsInDiv = element.getElementsByTagName("font");
	for (var i = 0; i < elemsInDiv.length; i++) {
		elemsInDiv[i].size = null;
		elemsInDiv[i].face = null;
	}
}

function changeFontOfElement(inputElement)
{
    var fontIncreased = false;
    var fontDecreased = false;
    var done = false;
	var textElementStyle;
	var textElementFontSize;

	while (! done) {
		var testedForIncrease = false;
		gTextHeight = inputElement.offsetHeight;
		textElementFontSize = parseInt(gCurrentFontSize);
		
		if ( (gTextHeight > gMaxSize) && (textElementFontSize > kMinFontSize) && ! fontIncreased ) {
			inputElement.style.fontSize = (textElementFontSize - 1) + "px";
			setMaxSize(inputElement.style.fontSize);
			fontDecreased = true;
		}
		else if ( (gTextHeight <= (160 - 2*textElementFontSize)) && (textElementFontSize < 18) && ! fontDecreased  ) {
			testedForIncrease = true;
			inputElement.style.fontSize = (textElementFontSize + 1) + "px";
			var testHeight = inputElement.offsetHeight;
			if ( (testHeight <= gMaxSize)) {
				setMaxSize(inputElement.style.fontSize);
				gTextHeight = testHeight;
				fontIncreased = true;
			}
			else {
				inputElement.style.fontSize = textElementFontSize + "px";
				if (testedForIncrease)
					done = true;
			}
		}
		else {
			done = true;
		}
		if (fontIncreased || fontDecreased)
			gCurrentFontSize = inputElement.style.fontSize;
	}
	
    return fontIncreased | fontDecreased;
}

function myContainCheck(container, candidate) {
	do {
		if (container == candidate)
			return true;
			
		candidate = candidate.parentNode;
	} while (candidate)
	
	return false;
}

function dumpAttrs(attrs) {
	for (var i = 0 ; i < attrs.length; i++) {
		if (widget) alert("attr " + i + " " + attrs[i].name + " " +  attrs[i].value);
	}
}
